/* ============ */
/* gapdefs.h	*/
/* ============ */
/* ==================================================================== */
/*     	      TYPEDEFS, #DEFINES AND PROTOTYPES FOR GAP TEST		*/
/* ==================================================================== */
# if defined(__GAPDEFS_H__)
#	/* Do Nothing */
# else
#	define	__GAPDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;

#define	FALSE	0
#define	TRUE	1
# endif

#define MAX_CELL_XPCT		100	/* Max. Expected Counts/Cell	*/
#define MIN_CELL_XPCT		5
#define	MAX_GAP_LEN		100	/* Max. No. Variates Per Gap	*/
#define	MIN_GAP_LEN		2
#define	MAX_NUM_GAPS		65535L
#define	MIN_NUM_GAPS		10

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	GapDataStru
    {
	int	NumCategories;	/* No. Categories to Receive Tallies	*/
	int	UserCellExpect;	/* User-Minimum Cell Expectation	*/
	int	MaxGapLen;	/* Maximum Length of Tabulated Gap	*/
	long	NumGaps;	/* Number of Gaps to be Tabulated	*/
	long	TotNumGen;	/* Number Variates Generated This Run	*/
	long	UserNumGaps;	/* No. Gaps to meet UserCellExpect	*/
	long	IdealNumGaps;	/* No. Gaps to meet MIN_CELL_XPCT	*/
	long	MaxGenPerGap;	/* FAILURE Criteria for Generator	*/
	long	ActMaxPerGap;	/* Actual Maximum Generated for Gaps	*/
	int	CallStatusOK;	/* 0 = FALSE, 1 = TRUE			*/
	int	NotEnough;	/* # Categories < UserCellExpect	*/
	UINT	LoGapInt;	/* (RAND_MAX+1) * GapLoLimit			*/
	UINT	HiGapInt;	/* (RAND_MAX+1) * GapHiLimit			*/
	double	GapLoLimit;	/* Lower Boundary on Specified Gap	*/
	double	GapHiLimit;	/* Upper Boundary on Specified Gap	*/
	double	*CellExpect;	/* Calculated Cell Expectations 	*/
	double	GapChiSq;	/* Gap-Run Chi-Square Data		*/
	int	(*RandFun) F((void));/* Addr. of Generating Function	*/
    }
	GAP_DATA_STRU;

extern	void	CalcGapProbs F((int, double, double, double *));
extern	void	CalcGapMeanStdDev F((int, double, double *, double *));
extern	void	CalcGapChiSq F((struct GapDataStru *));
extern	UINT	GenGapData F((struct GapDataStru *));
extern	void	SetGapControls F((struct GapDataStru *));

# undef F
/* INDENT ON */

# endif				/* <<< __GAPDEFS_H__ >>> */
